% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalized_mean.R
\name{gmean}
\alias{gmean}
\alias{gmean.default}
\title{Geometric Mean}
\usage{
gmean(x, ...)

\method{gmean}{default}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An \R object. Currently there are methods for numeric/logical
vectors and date, date-time and time interval objects. Complex vectors
are allowed for \code{trim = 0}, only.}

\item{...}{further arguments passed to or from other methods.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}
}
\value{
The geometric mean of the values in \code{x} is computed, as a numeric
or complex vector of length one. If \code{x} is not logical (coerced to
numeric), numeric (including integer) or complex, \code{NA_real_} is returned,
with a warning.
}
\description{
Geometric Mean
}
\examples{
x <- c(1:10, 50)
xm <- gmean(x)

}
\seealso{
\code{\link{mean}} for the arithmetic mean and \code{\link{hmean}} for the harmonic
mean.
}
