% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv_nu.R
\name{deriv_nu}
\alias{deriv_nu}
\title{Derivatives and Information for Nu}
\usage{
deriv_nu(
  y = NULL,
  omega = NULL,
  gamma = NULL,
  lambda = NULL,
  zeta = NULL,
  nu = NULL,
  kappa = NULL,
  nu_mu = NULL,
  nu_sigma2 = NULL,
  link = NULL
)
}
\arguments{
\item{y}{Item response matrix (K by IJ).}

\item{omega}{Contrast effects matrix (K by
MN).}

\item{gamma}{Contrast codes matrix (JM by MN).}

\item{lambda}{Item slope matrix (IJ by JM).}

\item{zeta}{Specific effects matrix (K by
JM).}

\item{nu}{Item intercept matrix  (IJ by 1).}

\item{kappa}{Item guessing matrix  (IJ by 1). Defaults to 0.}

\item{nu_mu}{Mean prior for nu (1 by 1)}

\item{nu_sigma2}{Covariance prior for nu (1 by 1)}

\item{link}{Choose between "logit" or "probit" link functions.}
}
\value{
List with elements fpd (1 by 1 vector of first partial derivatives
for nu), spd (1 by 1 matrix of second partial derivatives for nu),
post_info (1 by 1 posterior information matrix for nu), and fisher_info
(1 by 1) Fisher information matrix for nu). Within each of these
elements, there are sub-elements for all IJ items.
}
\description{
This function calculates the matrix of first partial derivatives, the matrix
of second partial derivatives, and matrix of posterior and Fisher information
for the posterior distribution with respect to nu (easiness) based on the
slope-intercept form of the 1-, 2-, or 3-P item response theory model.
}
\section{Dimensions}{

I = Number of items per condition; J = Number of conditions; K = Number of
examinees; M Number of ability (or trait) dimensions; N Number of contrasts
(should include intercept).
}

\section{A Note About Model Notation}{

The function converts GLLVM notation to the more typical IRT notation used by
Segall (1996) for ease of referencing formulas (with the exception of using
the slope-intercept form of the item response model).
}

\references{
Carlson, J. E. (1987). {Multidimensional Item Response Theory Estimation: A
computer program} (Reprot No. ONR87-2). The American College Testing Program.
https://apps.dtic.mil/sti/pdfs/ADA197160.pdf

Segall, D. O. (1996). Multidimensional adaptive testing.
\emph{Psychometrika, 61(2)}, 331-354. https://doi.org/10.1007/BF02294343

Segall, D. O. (2009). Principles of Multidimensional Adaptive Testing. In W.
J. van der Linden & C. A. W. Glas (Eds.), \emph{Elements of Adaptive Testing}
 (pp. 57-75). https://doi.org/10.1007/978-0-387-85461-8_3
}
\keyword{internal}
