% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv_lambda.R
\name{deriv_lambda}
\alias{deriv_lambda}
\title{Derivatives and Information for Lambda}
\usage{
deriv_lambda(
  y = NULL,
  omega = NULL,
  gamma = NULL,
  lambda = NULL,
  zeta = NULL,
  kappa = NULL,
  nu = NULL,
  lambda_mu = NULL,
  lambda_sigma2 = NULL,
  link = NULL
)
}
\arguments{
\item{y}{Item response matrix (K by IJ).}

\item{omega}{Contrast effects matrix (K by
MN).}

\item{gamma}{Contrast codes matrix (JM by MN).}

\item{lambda}{Item slope matrix (IJ by JM).}

\item{zeta}{Specific effects matrix (K by
JM).}

\item{kappa}{Item guessing matrix  (IJ by 1). Defaults to 0.}

\item{nu}{Item intercept matrix  (IJ by 1).}

\item{lambda_mu}{Mean prior for lambda (1 by JM)}

\item{lambda_sigma2}{Covariance prior for lambda (JM by JM)}

\item{link}{Choose between "logit" or "probit" link functions.}
}
\value{
List with elements fpd (1 by JM vector of first partial derivatives
for alpha), spd (JM by JM matrix of second partial derivatives for alpha),
post_info (JM by JM posterior information matrix for alpha), and fisher_info
(JM by JM Fisher information matrix for alpha). Within each of these
elements, there are sub-elements for all IJ items
}
\description{
This function calculates the matrix of first partial derivatives, the matrix
of second partial derivatives, and matrix of posterior and Fisher information
for the posterior distribution with respect to alpha (discrimination) based
on the slope-intercept form of the 1-, 2-, or 3-P item response theory model.
}
\section{Dimensions}{

I = Number of items per condition; J = Number of conditions; K = Number of
examinees; M Number of ability (or trait) dimensions; N Number of contrasts
(should include intercept).
}

\section{A Note About Model Notation}{

The function converts GLLVM notation to the more typical IRT notation used by
Segall (1996) for ease of referencing formulas (with the exception of using
the slope-intercept form of the item response model).
}

\references{
Carlson, J. E. (1987). {Multidimensional Item Response Theory Estimation: A
computer program} (Reprot No. ONR87-2). The American College Testing Program.
https://apps.dtic.mil/sti/pdfs/ADA197160.pdf

Segall, D. O. (1996). Multidimensional adaptive testing.
\emph{Psychometrika, 61(2)}, 331-354. https://doi.org/10.1007/BF02294343

Segall, D. O. (2009). Principles of Multidimensional Adaptive Testing. In W.
J. van der Linden & C. A. W. Glas (Eds.), \emph{Elements of Adaptive Testing}
 (pp. 57-75). https://doi.org/10.1007/978-0-387-85461-8_3
}
\keyword{internal}
