% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{pvaluesceucl}
\alias{pvaluesceucl}
\title{Calculate the p_values matrix or matrices (two or more) for each pair of factors inside variable or variables (two or more), using Euclidean distance as a base.}
\usage{
pvaluesceucl(
  dataset,
  formula,
  pvalue.method = "permutation",
  plot = TRUE,
  seed = NULL,
  min_group_size = 3
)
}
\arguments{
\item{dataset}{A dataframe.}

\item{formula}{A variable or variables (two or more) with factors which you want to calculate the Euclidean distances matrix or matrices (two or more).}

\item{pvalue.method}{A p_value method used to calculate the matrix or matrices (two or more), the default value is "permutation". Another method is "bootstrap".}

\item{plot}{if TRUE, plot the p_values heatmap or heatmaps (two or more). The default value is TRUE.}

\item{seed}{Optionally, set a seed for "bootstrap" and "permutation" methods.}

\item{min_group_size}{Minimum group size to maintain. The default value is 3, therefore groups, inside variables, with less than 3 observations will be discarded.}
}
\value{
A list containing a matrix or matrices (two or more) of p_values and, optionally, the plot.
}
\description{
Using the Euclidean distance for the distances calculation, this function takes a dataframe, a variable or variables (two or more), a p_value method such as "bootstrap" and "permutation" and returns the p_values matrix or matrices (two or more) between each pair of factors and a plot or plots (two or more) if the user select TRUE or leaves the parameter without argument.
}
\examples{
# Example with iris dataset

# Calculate p_values of "Species" variable in iris dataset
pvaluesceucl(iris,~Species, pvalue.method = "permutation"
, min_group_size = 3)

# Example with mtcars dataset

# Calculate p_values of "am" variable in mtcars dataset
pvaluesceucl(mtcars,~am + carb, 
pvalue.method = "bootstrap", 
seed = 100, min_group_size = 2)

}
