% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreProcessing.R
\name{fin.csv}
\alias{fin.csv}
\title{Final aggregation for CSV-Data}
\usage{
fin.csv(
  envrmt = .GlobalEnv$envrmt,
  method = "monthly",
  crs = NULL,
  save_output = TRUE,
  ...
)
}
\arguments{
\item{envrmt}{variable name of your envrmt list created using climodr's `envi.create` function. Default = envrmt.}

\item{method}{character. Either "daily", monthly" or "annual". Also depends on the available data.}

\item{crs}{character. If null, coordinate reference system from project files will be taken. Otherwise
data will be reprojected into this crs.}

\item{save_output}{logical. If cleaned data should be saved permanently in the Environment put save_output = TRUE.
Otherwise the output will be saved in the temporary directory. Default: FALSE.}

\item{...}{arguments passed down from other functions.}
}
\value{
List
}
\description{
Extract the raster values of all raster layers from a scene at the station
coordinates at each time stamp. The extracted data will be attached to the
station data so there is a .csv-file with coordinates, sensor data (response values)
and extracted raster data (predictor values). The data is ready to be used for modelling.
}
\examples{
#create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

# Load the climodr example data into the current climodr environment
clim.sample(envrmt = envrmt)

#prepare csv-files
prep.csv(envrmt = envrmt,
         method = "proc",
         save_output = TRUE)

#process csv-files
csv_data <- proc.csv(envrmt = envrmt,
                     method = "monthly",
                     rbind = TRUE,
                     save_output = TRUE)

# Crop all raster bands
crop.all(envrmt = envrmt,
         method = "MB_Timeseries",
         overwrite = TRUE)

# Calculate Indices from cropped raster bands
calc.indices(envrmt = envrmt,
             vi = "all",
             bands = c("blue", "green", "red",
                       "nir", "nirb",
                       "re1", "re2", "re3",
                       "swir1", "swir2"),
             overwrite = TRUE)

#extract station coordinates
csv_spat <- spat.csv(envrmt = envrmt,
                     method = "monthly",
                     des_file = "plot_description.csv",
                     save_output = TRUE)


#extract predictor values from raster files
csv_fin <- fin.csv(envrmt = envrmt,
                   method = "monthly",
                   save_output = TRUE)
head(csv_fin)

}
\seealso{
`prep.csv`, `proc.csv`, `spat.csv`, `calc.indices`
}
