% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{cli_vec}
\alias{cli_vec}
\title{Add custom cli style to a vector}
\usage{
cli_vec(x, style = list())
}
\arguments{
\item{x}{Vector that will be collapsed by cli.}

\item{style}{Style to apply to the vector. It is used as a theme on
a \code{span} element that is created for the vector. You can set \code{vec-sep},
\code{vec-sep2}, and \code{vec-last} to modify the general separator,
the 2-item separator, and the last separator.}
}
\description{
Add custom cli style to a vector
}
\details{
You can use this function to change the default parameters of
collapsing the vector into a string, see an example below.

The style is added as an attribute, so operations that remove
attributes will remove the style as well.
\subsection{Custom collapsing separator}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{v <- cli_vec(
  c("foo", "bar", "foobar"),
  style = list("vec-sep" = " & ", "vec-last" = " & ")
)
cli_text("My list: \{v\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> My list: foo &amp; bar &amp; foobar.                                                    
</pre></div>
}}

}

\subsection{Custom truncation}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- cli_vec(names(mtcars), list("vec-trunc" = 3))
cli_text("Column names: \{x\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> Column names: mpg, cyl, disp, …, gear, and carb.                                
</pre></div>
}}

}
}
\seealso{
\code{\link[=cli_format]{cli_format()}}
}
