% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaExplain.R
\name{ciu.list.to.frame}
\alias{ciu.list.to.frame}
\title{ciu.list.to.frame}
\usage{
ciu.list.to.frame(ciu.list, out.ind = 1)
}
\arguments{
\item{ciu.list}{\link{list} of ciu.result objects.}

\item{out.ind}{Index of output to extract.}
}
\value{
\link{data.frame} with same columns as ciu.result object but with one row
per input feature.
}
\description{
Convert \link{list} of ciu.result objects into corresponding \link{data.frame} for
given output.
}
\examples{
library(MASS)
iris_train <- iris[, 1:4]
iris_lab <- iris$Species
iris.lda <- lda(iris_train, iris_lab)
instance <- iris[100,1:4]
ciu <- ciu.new(iris.lda, Species~., iris)
meta <- ciu$meta.explain(instance)
ciu.list.to.frame(meta$ciuvals)
}
\author{
Kary Främling
}
