% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/playfair.R
\name{playfair}
\alias{playfair}
\title{playfair}
\usage{
playfair(word, key = "", added_letter = "x", encrypt = TRUE)
}
\arguments{
\item{word}{Word or phrase to be encrypted or decrypted}

\item{key}{Word for creating the modified Polybius square}

\item{added_letter}{Letter to be added in case two letters of a pair are identical; usually "x" is used}

\item{encrypt}{If `TRUE` (default), the program ciphers the input word, If `FALSE`, the program decrypts it.}
}
\value{
a string
}
\description{
The Playfair cipher is a symmetric method which encrypts pairs of letters
 using a modified Polybius square
}
\examples{
playfair( "instruments", "monarchy", added_letter = "z")
playfair("gatlmzclrqtx", "monarchy", added_letter = "z", encrypt = FALSE)

}
\references{
https://en.wikipedia.org/wiki/Playfair_cipher
}
