% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_mcmc_step.R
\name{PartitionMCMC}
\alias{PartitionMCMC}
\title{Transition objects.
Partition MCMC}
\usage{
PartitionMCMC(
  proposal = DefaultProposal(),
  temperature = 1,
  prerejection = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{proposal}{Proposal function. Default is the DefaultProposal.}

\item{temperature}{Numeric value representing the temperature to raise the
score to. Default is 1.}

\item{prerejection}{Boolean flag to reject due to the proposal disobeying the
black or white lists. Only set to FALSE if you want to understand
how often you are proposing states that disobey the black or white lists. Can
be useful for debugging or understanding the efficiency of specific proposal
distributions.}

\item{verbose}{Flag to pass MCMC information.}
}
\value{
Function that takes the current state and scorer that outputs a new
state.
}
\description{
This is a constructor for a single Tempered Partition MCMC step. The function
constructs an environment with the proposal, inverse temperature, and verbose
flag. It then returns a function that takes the current_state and a scorer
object. This only allows the scores to be raised to a constant temperature
for every step.
}
\details{
One step implementation of the tempered partition MCMC.
}
\examples{
dag <- UniformlySampleDAG(c('A', 'B', 'C', 'D', 'E', 'F'))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer,
  data = bnlearn::learning.test
  )

current_state <- list(
  state = partitioned_nodes,
  log_score = ScoreLabelledPartition(partitioned_nodes, scorer)
  )

pmcmc <- PartitionMCMC(proposal = DefaultProposal(), temperature = 1.0)
pmcmc(current_state, scorer)

}
