% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorers.R
\name{CreateScorer}
\alias{CreateScorer}
\title{Scorer constructor}
\usage{
CreateScorer(
  scorer = BNLearnScorer,
  ...,
  max_parents = Inf,
  blacklist = NULL,
  whitelist = NULL,
  cache = FALSE,
  nthreads = 1
)
}
\arguments{
\item{scorer}{A scorer function that takes (node, parents) as parameters.
Default is BNLearnScorer.}

\item{...}{Parameters to pass to scorer.}

\item{max_parents}{The maximum number of allowed parents. Default is
infinite.}

\item{blacklist}{A boolean matrix of (parent, child) pairs where TRUE
represents edges that cannot be in the DAG. Default is NULL which
represents no blacklisting.}

\item{whitelist}{A boolean matrix of (parent, child) pairs where TRUE
represents edges that must be in the DAG. Default is NULL which represents
no whitelisting.}

\item{cache}{A boolean to indicate whether to build the cache. The
cache only works for problems where the scorer only varies as a function of
(node, parents). Default is FALSE.}

\item{nthreads}{Number of threads used to construct cache.}
}
\value{
A list with entries:
\itemize{
\item scorer: Function that takes (node, parents) as parameters and returns
the score.
\item parameters: List of extra parameters passed to the scorer.
\item max_parents: Integer representing the maximum number of possible
possible parents that any child can have.
\item blacklist: Matrix where each cell represents the (parent, child) pairs
that must not be present when equal to 1.
\item whitelist: Matrix where each cell represents the (parent, child) pairs
that must be present when equal to 1.
state estimated using the MCMC sampling frequency.
}
}
\description{
Scorer constructor
}
\examples{
scorer <- CreateScorer(data = bnlearn::asia)

}
