% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_mzml.R
\name{write_mzml}
\alias{write_mzml}
\title{Write mzML}
\usage{
write_mzml(
  data,
  path_out,
  sample_name = NULL,
  what = NULL,
  instrument_info = NULL,
  compress = TRUE,
  indexed = TRUE,
  force = FALSE,
  show_progress = TRUE,
  verbose = getOption("verbose")
)
}
\arguments{
\item{data}{List of data.frames or data.tables containing spectral data.}

\item{path_out}{The path to write the file.}

\item{sample_name}{The name of the file. If a name is not provided, the name
will be derived from the \code{sample_name} attribute.}

\item{what}{Which streams to write to mzML: \code{"ms1"}, \code{"ms2"},
\code{"tic"}, \code{"bpc"}, and/or \code{"dad"}.}

\item{instrument_info}{Instrument info to write to mzML file.}

\item{compress}{Logical. Whether to use zlib compression. Defaults to
\code{TRUE}.}

\item{indexed}{Logical. Whether to write indexed mzML. Defaults to
\code{TRUE}.}

\item{force}{Logical. Whether to overwrite existing files at \code{path_out}.
Defaults to \code{FALSE}.}

\item{show_progress}{Logical. Whether to show progress bar. Defaults to
\code{TRUE}.}

\item{verbose}{Logical. Whether or not to print status messages.}
}
\value{
Invisibly returns the path to the written mzML file.
}
\description{
This function constructs mzML files by writing XML strings directly to a file
connection. While this approach is fast, it may be less flexible than
methods based on an explicit Document Object Model (DOM).
}
\details{
The function supports writing various types of spectral data including MS1,
TIC (Total Ion Current), BPC (Base Peak Chromatogram), and DAD
(Diode Array Detector) data. Support for MS2 may be added in a future release.

If \code{indexed = TRUE}, the function will generate an indexed mzML file, which
allows faster random access to spectra.
}
\seealso{
Other write functions: 
\code{\link{write_andi_chrom}()},
\code{\link{write_chroms}()}
}
\author{
Ethan Bass
}
\concept{write functions}
