% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_shimadzu_lcd.R
\name{read_sz_lcd_2d}
\alias{read_sz_lcd_2d}
\title{Read 'Shimadzu' LCD 2D data}
\usage{
read_sz_lcd_2d(
  path,
  format_out = "data.frame",
  data_format = "wide",
  read_metadata = TRUE,
  metadata_format = "shimadzu_lcd",
  scale = TRUE
)
}
\arguments{
\item{path}{Path to 'Shimadzu' \code{.lcd} 2D data file.}

\item{format_out}{Matrix or data.frame.}

\item{data_format}{Either \code{wide} (default) or \code{long}.}

\item{read_metadata}{Logical. Whether to attach metadata.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{scale}{Whether to scale the data by the value factor.}
}
\value{
One or more 2D chromatograms from the chromatogram streams in
\code{matrix} or \code{data.frame} format, according to the value of
\code{format_out}. If multiple chromatograms are found, they will be returned
as a list of matrices or data.frames. The chromatograms will be returned in
\code{wide} or \code{long} format according to the value of \code{data_format}.
}
\description{
Reads 2D PDA data stream from 'Shimadzu' \code{.lcd} files.
}
\details{
A parser to read chromatogram data streams from 'Shimadzu' \code{.lcd} files.
LCD files are encoded as 'Microsoft' OLE documents. The parser relies on the
\href{https://pypi.org/project/olefile/}{olefile} package in Python to unpack the
files. The chromatogram data is encoded in streams titled
\code{LSS Raw Data:Chromatogram Ch<#>}. The chromatogram data streams begin
with a 24-byte header.

The 24 byte header consists of the following fields:
\itemize{
\item 4 bytes: segment label (\code{17234}).
\item 4 bytes: Little-endian integer specifying the sampling rate (in milliseconds).
\item 4 bytes: Little-endian integer specifying the number of values
in the file.
\item 4 bytes: Little-endian integer specifying the total number of bytes
in the file.
\item 8 bytes of \code{00}s
}

Each segment is divided into multiple sub-segments, which begin and end with an
integer specifying the length of the sub-segment in bytes. All known values
in this data stream are little-endian and the data are delta-encoded. The
first hexadecimal digit of each value is a sign digit
specifying the number of bytes in the delta and whether the value is positive
or negative. The sign digit represents the number of hexadecimal digits used
to encode each value. Even numbered sign digits correspond to positive deltas,
whereas odd numbers indicate negative deltas. Positive values are encoded as
little-endian integers, while negative values are encoded as two's
complements. The value at each position is derived by subtracting the delta
at each position from the previous value.
}
\seealso{
Other 'Shimadzu' parsers: 
\code{\link{read_shimadzu}()},
\code{\link{read_shimadzu_gcd}()},
\code{\link{read_shimadzu_lcd}()},
\code{\link{read_shimadzu_qgd}()},
\code{\link{read_sz_lcd_3d}()}
}
\author{
Ethan Bass
}
\concept{'Shimadzu' parsers}
