% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addEuclideanPath.R
\name{addEuclideanPath}
\alias{addEuclideanPath}
\title{Add Euclidean path from case/landmark to nearest or selected pump. (prototype)}
\usage{
addEuclideanPath(origin = 1, destination = NULL, type = "case-pump",
  vestry = FALSE, latlong = FALSE, case.set = "observed",
  location = "nominal", weighted = TRUE, distance.unit = "meter",
  time.unit = "second", walking.speed = 5, include.landmarks = TRUE,
  long.title = FALSE, mileposts = TRUE, milepost.unit = "distance",
  milepost.interval = NULL, alpha.level = 1)
}
\arguments{
\item{origin}{Numeric. Vector of origin(s) (numeric ID or character name landmark/pump ).}

\item{destination}{Numeric. Vector of destination(s) (numeric or landmark/pump name).}

\item{type}{Character. Path case to pump. FALSE is all other combinations of cases, landmarks and pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the map in the Vestry Report. \code{FALSE} uses the 13 pumps from the original map.}

\item{latlong}{Logical.}

\item{case.set}{Character. "observed" or "expected".}

\item{location}{Character. For cases and pumps. "nominal", "anchor" or "orthogonal".}

\item{weighted}{Logical. \code{TRUE} computes shortest path in terms of road length. \code{FALSE} computes shortest path in terms of the number of nodes.}

\item{distance.unit}{Character. Unit of distance: "meter" or "yard".}

\item{time.unit}{Character. "hour", "minute", or "second".}

\item{walking.speed}{Numeric. Walking speed in km/hr.}

\item{include.landmarks}{Logical. Include landmarks as cases.}

\item{long.title}{Logical. Tile with names.}

\item{mileposts}{Logical. Plot mile/time posts.}

\item{milepost.unit}{Character. "distance" or "time".}

\item{milepost.interval}{Numeric. Mile post interval unit of distance (yard or meter) or unit of time (seconds).}

\item{alpha.level}{Numeric. Alpha level transparency for path: a value in [0, 1].}
}
\description{
Add Euclidean path from case/landmark to nearest or selected pump. (prototype)
}
