% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{compute_number_jumps}
\alias{compute_number_jumps}
\title{Compute the number of jumps}
\usage{
compute_number_jumps(data, countDuplicated = FALSE)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and
\code{state}, associated state.}

\item{countDuplicated}{if \code{TRUE}, jumps in the same state are counted as jump}
}
\value{
A vector containing the number of jumps for each individual
}
\description{
For each individual, compute the number of jumps performed
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)

# compute the number of jumps
nJump <- compute_number_jumps(d_JK)
}
\seealso{
\code{\link{hist.njump}}

Other Descriptive statistics: 
\code{\link{boxplot.timeSpent}()},
\code{\link{compute_duration}()},
\code{\link{compute_time_spent}()},
\code{\link{estimate_pt}()},
\code{\link{hist.duration}()},
\code{\link{hist.njump}()},
\code{\link{plot.pt}()},
\code{\link{plotData}()},
\code{\link{statetable}()},
\code{\link{summary_cfd}()}
}
\author{
Cristian Preda, Quentin Grimonprez
}
\concept{Descriptive statistics}
