% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/what_if_2d.R
\name{what_if_2d}
\alias{what_if_2d}
\title{What-If 2D Plot}
\usage{
what_if_2d(
  explainer,
  observation,
  grid_points = 101,
  selected_variables = NULL
)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'DALEX::explain' function}

\item{observation}{a new observarvation for which predictions need to be explained}

\item{grid_points}{number of points used for response path. Will be used for both variables}

\item{selected_variables}{if specified, then only these variables will be explained}
}
\value{
An object of the class 'what_if_2d_explainer'.
It's a data frame with calculated average responses.
}
\description{
This function calculates what if scores for grid of values spanned by two variables.
}
\examples{
library("DALEX")
 \dontrun{
library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
      no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
      data = apartmentsTest[,2:6], y = apartmentsTest$m2.price)

new_apartment <- apartmentsTest[1, ]
new_apartment

wi_rf_2d <- what_if_2d(explainer_rf, observation = new_apartment,
         selected_variables = c("surface", "floor", "no.rooms"))
wi_rf_2d
plot(wi_rf_2d)
}
}
