% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{pop_data_by_reg}
\alias{pop_data_by_reg}
\title{Filter Population Data by Province}
\usage{
pop_data_by_reg(data, reg)
}
\arguments{
\item{data}{A data frame or tibble containing population data.
Must include a column named \code{province_id}.}

\item{reg}{Integer or character. The province ID to filter by.}
}
\value{
A tibble (or data frame) containing only rows for the specified province.
}
\description{
Filter population data based on a specified province ID. This function is
intended for use with population datasets loaded via \code{\link[=load_pop_data]{load_pop_data()}},
but can work with any data frame that includes a \code{province_id} column.
}
\examples{
# Load harmonized data
dat <- load_pop_data(harmonized = TRUE, smoothing = 1)

# Filter data for province ID 0 (Indonesia)
pop_data_by_reg(dat, reg = 0)
}
\seealso{
\code{\link[=load_pop_data]{load_pop_data()}}, \code{\link[=pop_data_by_year]{pop_data_by_year()}}
}
