% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.CDMid.R
\name{is.CDMid}
\alias{is.CDMid}
\title{Check whether a CDM is identified}
\usage{
is.CDMid(fit, N = 10000, timesJ = 20, Wald = FALSE, verbose = TRUE)
}
\arguments{
\item{fit}{An object of class RDINA or GDINA (Ma & de la Torre, 2020).}

\item{N}{A \emph{numeric} value that indicates the number of respondents to simulate. Default is 10000.}

\item{timesJ}{A \emph{numeric} value that indicates the number of times the test length is multiplied. Default is 20.}

\item{Wald}{A \code{logical} value that indicates whether the Wald method should be used to find the best model for each item (only applicable if fit is of class \code{GDINA}). Default is \code{FALSE}.}

\item{verbose}{A \code{logical} value that indicates whether information about the process should be printed or not. Default is \code{TRUE}.}
}
\value{
\code{is.CDMid} returns an object of class \code{is.CDMid}.
\describe{
\item{\code{total}}{Overall classification accuracy (CCA) and number of posterior multiple modes (PMM). A CCA = 1 indicates that all latent classes are identified (\code{vector}).}
\item{\code{class}}{Classification accuracy (CCA) and number of posterior multiple modes (PMM) for each latent class. A CCA = 1 indicates that the latent class is identified (\code{data.frame}).}
}
}
\description{
Uses a post-hoc simulation approach to check whether a cognitive diagnosis model is identified (i.e., all latent classes are distinguishable; de la Torre et al., 2023).
}
\examples{
\donttest{
library(GDINA)
dat <- sim30GDINA$simdat
Q <- sim30GDINA$simQ
fit <- GDINA(dat, Q)
id <- is.CDMid(fit)
}
}
\references{
de la Torre, J., Sorrel, M. A., & Nájera, P. (2023, July). \emph{Cognitive diagnosis modeling}. Workshop at the VII International Psychometric Summer School "Applied Psychometrics in Psychology and Education". Yerevan, Armenia.
}
\author{
{Pablo Nájera, Universidad Pontificia Comillas}
}
