#' Inverse cumulative distribution function for t distribution
#'
#' Computes the value of sample mean corresponding to the input quantile p of the t distribution for n-1 degrees of freedom
#'
#' Do not call qtmean() directly.
#' Pass DISTR="tmean" to cdfinv() when computing intervals for the
#' normal mean when the variance is unknown.
#' The parameter name to be passed to cdfinv() is mean.
#' The additional arguments s2 (sample variance) and
#' n (sample size) are to be passed to cdfinv().
#'
#' @param p value of cdf (named in accordance with R standards)
#' @param mean the assumed normal mean
#' @param s2 the observed sample variance (pass this as an extra argument to cdfinv())
#' @param n the sample size (pass this as an extra argument to cdfinv())
#'
#' @returns The value of sample mean corresponding to the input quantile p of the t distribution for n-1 degrees of freedom
#'
#' @author Peter E. Freeman, \email{pfreeman@@cmu.edu}
#'
qtmean <- function(p,mean,s2,n)
{
  if ( n == 1 ) stop("At least two observations are required when the variance is unknown.")
  qt(p,n-1)*sqrt(s2/n)+mean
}
