% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expansions.R
\name{expand_as_numeric}
\alias{expand_as_numeric}
\title{Numeric model matrix for continuous convolution}
\usage{
expand_as_numeric(x)
}
\arguments{
\item{x}{a vector or data frame with numeric, ordered, or factor columns.}
}
\value{
A numeric matrix containing the expanded variables. It has additional
type \code{expanded_as_numeric} and \code{attr(, "i_disc")} cntains the indices of
discrete variables.
}
\description{
Turns ordered variables into integers and expands factors as binary dummy
codes. \code{\link[=cont_conv]{cont_conv()}} additionally adds noise to discrete variables, but this is only
useful for estimation. \verb{[cc_prepare()]} can be used to evaluate an already
fitted estimate.
}
\examples{
# dummy data with discrete variables
dat <- data.frame(
    F1 = factor(rbinom(100, 4, 0.1), 0:4),
    Z1 = as.ordered(rbinom(100, 5, 0.5)),
    Z2 = as.ordered(rpois(100, 1)),
    X1 = rnorm(100),
    X2 = rexp(100)
)

pairs(dat)
pairs(expand_as_numeric(dat))  # expanded variables without noise
pairs(cont_conv(dat))          # continuously convoluted data

}
