% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instance.R
\name{generate_instance_lfc}
\alias{generate_instance_lfc}
\title{Generate data sets under least favorable parameter configurations}
\usage{
generate_instance_lfc(
  nrep = 10,
  n = 100,
  prev = 0.5,
  random = FALSE,
  m = 10,
  se = 0.8,
  sp = 0.8,
  L = 1,
  rhose = 0,
  rhosp = 0,
  cortype = "equi",
  ...,
  data = NULL,
  job = NULL
)
}
\arguments{
\item{nrep}{(numeric) \cr integer, number of instances}

\item{n}{(numeric) \cr integer, total sample size}

\item{prev}{(numeric) \cr disease prevalence}

\item{random}{(logical) \cr fixed prevalence (FALSE) or simple random sampling (TRUE)}

\item{m}{(numeric) \cr integer, number of candidates}

\item{se}{(numeric) \cr sensitivity}

\item{sp}{(numeric) \cr specificity}

\item{L}{(numeric) \cr worst alternative is computed under side condition Acc <= L}

\item{rhose}{(numeric) \cr correlation parameter for sensitivity}

\item{rhosp}{(numeric) \cr correlation parameter for specificity}

\item{cortype}{(character) \cr  correlation type ("equi" or "ak1")}

\item{...}{(any) \cr further (named) arguments}

\item{data}{(NULL) \cr ignored (for batchtools compatibility)}

\item{job}{(NULL) \cr ignored (for batchtools compatibility)}
}
\value{
(list) \cr a single (LFC) simulation instance of length \code{nrep}
}
\description{
Generates a (simulation) instance, a list of multiple datasets to be processed
(analyzed) with \link{process_instance}. Ground truth parameters (Sensitvity & Specificity) are
least-favorable in the sense that the type-I error rate of the subsequently applied
multiple test procedures is maximized.

\strong{This function is only needed for simulation via batchtools, not relevant in interactive use!}
}
\details{
Utilizes same arguments as \link{draw_data_lfc} unless mentioned otherwise above.
}
