% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{progressInput}
\alias{progressInput}
\title{Create simple progress bar}
\usage{
progressInput(
  id,
  label = "",
  value = "35\%",
  outer.value = value,
  color = color.choice,
  vertical = FALSE,
  size = c("m", "s", "l"),
  striped = FALSE
)
}
\arguments{
\item{id}{id of the container}

\item{label}{title of the progress bar}

\item{value}{value of the progress bar in percent}

\item{outer.value}{value shown next to title}

\item{color}{color of the progress bar}

\item{vertical}{if the progress bar should be vertical or horizontal}

\item{size}{size of progress bar}

\item{striped}{whether to show the progressed bar background as striped}
}
\value{
an HTML content to display a progress bar
}
\description{
Create a progress bar within card container
}
\examples{
if (interactive()) {
library(shiny)
library(card.pro)

# Without much modification of defaults
progressInput(id="id1")

# Set color and value
progressInput(id="id1", value = "90\%", color = "green")
}
}
