% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_experiment.R
\name{make_experiment}
\alias{make_experiment}
\title{Make CalmrExperiment}
\usage{
make_experiment(
  design,
  model,
  parameters = NULL,
  timings = NULL,
  iterations = 1,
  miniblocks = TRUE,
  seed = NULL,
  .callback_fn = NULL,
  ...
)
}
\arguments{
\item{design}{A design \code{data.frame}.}

\item{model}{A string specifying the model name. One of \code{\link[=supported_models]{supported_models()}}.}

\item{parameters}{Optional. Parameters for a  model as
returned by \code{\link[=get_parameters]{get_parameters()}}.}

\item{timings}{Optional. Timings for a time-based design as
returned by \code{\link[=get_timings]{get_timings()}}}

\item{iterations}{An integer specifying the number of iterations per group.
Default = 1.}

\item{miniblocks}{Whether to organize trials in miniblocks. Default = TRUE.}

\item{seed}{A valid seed for the RNG to make the experiment.
Default = NULL, in which case the current RNG is used.}

\item{.callback_fn}{A function for keeping track of progress. Internal use.}

\item{...}{Extra parameters passed to other functions.}
}
\value{
A \linkS4class{CalmrExperiment} object.
}
\description{
Makes a \code{CalmrExperiment} object containing
the arguments necessary to run an experiment.
}
\note{
The miniblocks option will direct the sampling function to create
equally-sized miniblocks with random trials within a phase.
For example, the phase string "2A/2B" will create two miniblocks
with one of each trial. The phase string "2A/4B" will create two miniblocks
with one A trial, and 2 B trials. However, the phase string "2A/1B" will
not result in miniblocks, even if miniblocks here is set to TRUE.
}
\examples{
des <- data.frame(Group = "G1", P1 = "10A>(US)")
ps <- get_parameters(des, model = "HD2022")
make_experiment(
  design = des, parameters = ps,
  model = "HD2022", iterations = 2
)
}
\seealso{
\code{\link[=parse_design]{parse_design()}},
}
