% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/astronomical.R, R/solarlunar.R
\name{sunrise}
\alias{sunrise}
\alias{sunset}
\alias{moonset}
\alias{moonrise}
\title{Sun and moon rise and set given a date and location}
\usage{
sunrise(date, location)

sunset(date, location)

moonset(date, location)

moonrise(date, location)
}
\arguments{
\item{date}{Vector of dates on some calendar.}

\item{location}{Vector of locations of class "location", usually the output from the \code{location} function}
}
\value{
Time of sunrise
}
\description{
Calculate the time of sunrise, sunset, moonrise and moonset at a specific location and date. The
time zone of the location is used as specified in the \code{location} object. No adjustments are made for
daylight saving.
}
\examples{
melbourne <- location(-37.8136, 144.9631, 31, 10)
sydney <- location(-33.8688, 151.2093, 3, 10)
sunrise(gregorian_date(2025, 1, 1), c(melbourne, sydney))
sunset(gregorian_date(2025, 1, 1), c(melbourne, sydney))
moonrise(gregorian_date(2025, 1, 1), c(melbourne, sydney))
moonset(gregorian_date(2025, 1, 1), c(melbourne, sydney))
}
