% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calba.R
\name{neigh_ba}
\alias{neigh_ba}
\title{Neighborhood summaries for basal area and counts}
\usage{
neigh_ba(
  sp,
  gx,
  gy,
  ba,
  r,
  mu_values = NULL,
  dist_weighted = FALSE,
  exponential_normal = FALSE,
  edge_correction = c("none", "safe"),
  bounds = NULL
)
}
\arguments{
\item{sp}{A character or factor vector of species names.}

\item{gx}{Numeric x-coordinates of each tree.}

\item{gy}{Numeric y-coordinates of each tree.}

\item{ba}{Numeric basal area of each tree.}

\item{r}{Positive numeric radius within which neighbors are considered.}

\item{mu_values}{Optional numeric vector of decay parameters. When `NULL`, the decay table is omitted.}

\item{dist_weighted}{Logical flag passed to `ba_simple` to use a simple `ba / dist` weighting when `TRUE`.}

\item{exponential_normal}{Logical passed to `ba_decay` to select the exponential-normal kernel.}

\item{edge_correction}{Character; see `ba_simple()` for the `"safe"` option that skips edge focal trees.}

\item{bounds}{Optional numeric vector `c(xmin, xmax, ymin, ymax)` giving the plot extent.
When `NULL`, the range of `gx`/`gy` is used; supply bounds if your data do not span the full plot.}
}
\value{
A list with
* `summary`: data frame with `tree_id`, `species`, `con_ba`, `total_ba`, `con_count`, `total_count`.
* `decay`: (`NULL` or) long data frame with `tree_id`, `species`, `mu`, `con_ba`, `total_ba`.

The `summary` component also includes derived columns:
`prop_con_ba`, `het_ba`, `het_count`, and `competition_index`.
}
\description{
Provide a tidy summary of pairwise neighborhood basal area and counts,
optionally including decay results for a vector of decay parameters.
}
\examples{
sample_data <- data.frame(
  latin = sample(letters[1:4], 10, replace = TRUE),
  gx = runif(10, 0, 10),
  gy = runif(10, 0, 10),
  ba = runif(10, 10, 30)
)
neigh_ba(
  sp = sample_data$latin,
  gx = sample_data$gx,
  gy = sample_data$gy,
  ba = sample_data$ba,
  r = 3,
  mu_values = c(1, 3)
)
}
