% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_inter_search.R
\name{plot.sum.intsearc}
\alias{plot.sum.intsearc}
\alias{plot.sum.intsearch}
\title{Plot Summary object for interval search models}
\usage{
\method{plot}{sum.intsearch}(x, type = "summary", startN = 21, ...)
}
\arguments{
\item{x}{an object of class \code{sum.intsearch} as returned by the function
\code{\link[c060]{summary.intsearch}}.}

\item{type}{type of plot to be drawn, \code{type="summary"} will plot the
partial log likelihood deviance as a function of both tuning parameters
\eqn{\alpha} and log \eqn{\lambda}. The final solution will
be highlighted by solid red line. Alternativly, \code{type="points"} will
draw the distribution of initial and visited points of the interval search
plotted in chronological order.}

\item{startN}{number of initial points. Needed if \code{type="points"}}

\item{...}{additional argument(s)}
}
\description{
Produces a plot for summary object of a fitted interval search model. Plot
'visited' points against iteration steps. start.N points are initial points
selected before interval search starts.
}
\references{
Sill M., Hielscher T., Becker N. and Zucknick M. (2014),
\emph{c060: Extended Inference with Lasso and Elastic-Net Regularized Cox
and Generalized Linear Models, Journal of Statistical Software, Volume
62(5), pages 1--22.} https://doi.org/10.18637/jss.v062.i05.
}
\seealso{
\code{\link[c060]{EPSGO}}, \code{\link[c060]{summary.intsearch}}
}
\author{
Natalia Becker \ \email{natalia.becker@dkfz.de}
}
\keyword{plot}
