% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_muted_lists.R
\name{bs_get_muted_lists}
\alias{bs_get_muted_lists}
\title{Retrieve a user's (self) muted lists}
\usage{
bs_get_muted_lists(
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of actors
}
\description{
Retrieve a user's (self) muted lists
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/getListMutes.json}{graph/getListMutes.json (2023-10-02)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-02)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_get_muted_lists()
\dontshow{\}) # examplesIf}
}
\concept{graph}
