% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_model.R
\name{update_model.bgmfit}
\alias{update_model.bgmfit}
\alias{update_model}
\title{Update model}
\usage{
\method{update_model}{bgmfit}(
  model,
  newdata = NULL,
  recompile = NULL,
  expose_function = FALSE,
  verbose = FALSE,
  check_newargs = FALSE,
  envir = NULL,
  ...
)

update_model(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{newdata}{An optional \code{data.frame} to be used when updating the
model. If \code{NULL} (default), the data used in the original model fit is
reused. Note that data-dependent default priors are not automatically updated.}

\item{recompile}{A logical value indicating whether the Stan model should be
recompiled. When \code{NULL} (default), \strong{update_model()} tries to
internally determine whether recompilation is required. Setting
\code{recompile} to \code{FALSE} will ignore any changes in the Stan code.}

\item{expose_function}{A logical argument (default \code{FALSE}) to indicate
whether Stan functions should be exposed. If \code{TRUE}, any Stan
functions exposed during the model fit using \code{expose_function = TRUE}
in the \code{\link[=bsitar]{bsitar()}} function are saved and can be used in post-processing. By
default, \code{expose_function = FALSE} in post-processing functions,
except in \code{\link[=optimize_model]{optimize_model()}} where it is set to \code{NULL}. If
\code{NULL}, the setting is inherited from the original model fit. It must
be set to \code{TRUE} when adding \code{fit criteria} or \code{bayes_R2}
during model optimization.}

\item{verbose}{A logical argument (default \code{FALSE}) to specify whether
to print information collected during the setup of the object(s).}

\item{check_newargs}{A logical value (default \code{FALSE}) indicating whether
to check if the arguments in the original \code{model} fit and the
\code{update_model} are identical. When \code{check_newargs = TRUE} and the
arguments are identical, it indicates that an update is unnecessary. In this
case, the original \code{model} object is returned, along with a message if
\code{verbose = TRUE}.}

\item{envir}{The environment used for function evaluation. The default is
\code{NULL}, which sets the environment to \code{parent.frame()}. Since
most post-processing functions rely on \pkg{brms}, it is recommended to set
\code{envir = globalenv()} or \code{envir = .GlobalEnv}, especially for
derivatives like velocity curves.}

\item{...}{Other arguments passed to \code{[brms::brm()]}.}
}
\value{
An updated object of class \code{brmsfit}.
}
\description{
The \strong{update_model()} function is a wrapper around the
\code{update()} function from the \pkg{brms} package, which refits the model
based on the user-specified updated arguments.
}
\details{
This function is an adapted version of the \strong{update()} function
from the \pkg{brms} package.
}
\examples{

\donttest{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model fit to 
# the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether model fit object 'berkeley_exfit' exists
 berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# Update model
# Note that in case all arguments supplied to the update_model() call are 
# same as the original model fit (checked via check_newargs = TRUE), then  
# original model object is returned.   
# To explicitly get this information whether model is being updated or not, 
# user can set verbose = TRUE. The verbose = TRUE also useful in getting the
# information regarding what all arguments have been changed as compared to
# the original model.

model2 <- update_model(model, df = 5, check_newargs = TRUE, verbose = TRUE)

}

}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
