% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runningratio2.R
\name{runningratio2}
\alias{runningratio2}
\title{Running ratio with adaptive window}
\usage{
runningratio2(pos, numerator, denominator, at = NULL, window_denom = 100)
}
\arguments{
\item{pos}{Positions for the values.}

\item{numerator}{Values for numerator in ratio.}

\item{denominator}{Values for denominator in ratio.}

\item{at}{Positions at which running ratio is
calculated.  If NULL, \code{pos} is used.}

\item{window_denom}{Target denominator for window for calculating ratio}
}
\value{
A vector with the same length as the input \code{at} (or \code{pos},
if \code{at} is NULL), containing the running ratio.
}
\description{
Calculates a running ratio; a ratio sum(top)/sum(bottom) in a sliding window,
but rather than a fixed-width window, use nearest positions to give some
target denominator
}
\examples{
x <- 1:1000
y <- runif(1000, 1, 5)
z <- runif(1000, 1, 5)
plot(x, runningratio2(x, y, z, window_denom=10), type="l", lwd=2)
lines(x, runningratio2(x, y, z, window_denom=50), lwd=2, col="blue")
lines(x, runningratio2(x, y, z, window_denom=100), lwd=2, col="red")

}
\seealso{
\code{\link[=runningmean]{runningmean()}}, \code{\link[=runningratio]{runningratio()}}
}
\author{
Karl W Broman \email{broman@wisc.edu}
}
\keyword{univar}
