% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_file_versions.R
\name{box_version_history}
\alias{box_version_history}
\alias{box_version_number}
\title{Get version information}
\usage{
box_version_history(file_id)

box_version_number(file_id)
}
\arguments{
\item{file_id}{\code{numeric} or \code{character}, file ID at Box.}
}
\value{
\describe{
\item{\code{box_previous_versions()}}{
\code{data.frame} describing previous versions of file.}
\item{\code{box_version()}}{
\code{integer} version number of most-recent version of file.}
}
}
\description{
Box uses file versioning, but the API does not explicitly provide version
numbers. These functions use \code{modified_date} as a proxy to determine a
version number (\code{version_no}), which you can use with \code{\link[=box_dl]{box_dl()}} and
\code{\link[=box_read]{box_read()}}.
}
\details{
\itemize{
\item \code{box_version_history()}, previously called \code{box_previous_versions()},
gets information on all previous versions of a file. If there are no
previous versions, this function returns \code{NULL}.
\item \code{box_version_number()} gets the version number of the most-recent version.
\item To access the Box version API itself, you can use \code{\link[=box_version_api]{box_version_api()}}.
}
}
\references{
This function is a light wrapper of the
\href{https://developer.box.com/docs/}{box.com} API \code{versions} method.

\url{https://developer.box.com/reference/get-files-id-versions/}
}
\seealso{
\code{\link[=box_version_api]{box_version_api()}}, \code{\link[=box_dl]{box_dl()}}, \code{\link[=box_read]{box_read()}}
}
