% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobi_elliptic_functions.R
\name{jacobi_elliptic_functions}
\alias{jacobi_elliptic_functions}
\alias{jacobi_elliptic}
\alias{jacobi_cd}
\alias{jacobi_cn}
\alias{jacobi_cs}
\alias{jacobi_dc}
\alias{jacobi_dn}
\alias{jacobi_ds}
\alias{jacobi_nc}
\alias{jacobi_nd}
\alias{jacobi_ns}
\alias{jacobi_sc}
\alias{jacobi_sd}
\alias{jacobi_sn}
\title{Jacobi Elliptic Functions}
\usage{
jacobi_elliptic(k, u)

jacobi_cd(k, u)

jacobi_cn(k, u)

jacobi_cs(k, u)

jacobi_dc(k, u)

jacobi_dn(k, u)

jacobi_ds(k, u)

jacobi_nc(k, u)

jacobi_nd(k, u)

jacobi_ns(k, u)

jacobi_sc(k, u)

jacobi_sd(k, u)

jacobi_sn(k, u)
}
\arguments{
\item{k}{Elliptic modulus (0 <= k < 1)}

\item{u}{Argument of the elliptic functions}
}
\value{
For \code{jacobi_elliptic}, a list containing the values of the Jacobi elliptic functions: \code{sn}, \code{cn}, \code{dn}. For individual functions, a single numeric value is returned.
}
\description{
Functions to compute the Jacobi elliptic functions: sn, cn, dn, and others.
}
\examples{
# Jacobi Elliptic Functions
k <- 0.5
u <- 2
jacobi_elliptic(k, u)
# Individual Jacobi Elliptic Functions
jacobi_cd(k, u)
jacobi_cn(k, u)
jacobi_cs(k, u)
jacobi_dc(k, u)
jacobi_dn(k, u)
jacobi_ds(k, u)
jacobi_nc(k, u)
jacobi_nd(k, u)
jacobi_ns(k, u)
jacobi_sc(k, u)
jacobi_sd(k, u)
jacobi_sn(k, u)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/jacobi.html}{Boost Documentation} for more details on the mathematical background.
}
