% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thetaARBB.R
\name{thetaARBB}
\alias{thetaARBB}
\alias{thetaARRB}
\title{Compute the Extremal Index for Non-Atomic Markov Chains Using Pseudo-Regenerative
Blocks}
\usage{
thetaARBB(X)
}
\arguments{
\item{X}{A numeric vector representing the Markov chain.}
}
\value{
A numeric vector representing the extremal index at various quantile thresholds.
}
\description{
This function divides the input dataset into pseudo-blocks for
a non-atomic Markov chain
using a Nummelin splitting trick with estimated parameters.
We use the optimal small set computed by \code{\link{findBestEpsilon}}
function and calculates the extremal index using quantile-based thresholds.
}
\details{
The function uses \code{\link{GetPseudoBlocks}} to divide \code{X} into blocks
using to the estimated Nummelin splitting trick.
High quantiles from \code{X} are generated and used as thresholds to compute
statistics on each block, including sub-maximums
and block indices. These statistics are then used to calculate the extremal index,
a measure of extreme value clustering, across the blocks.
}
\examples{
\donttest{
coeff=0.75
X = arima.sim(n=200, list(ar = c(coeff)))
thetaB <- thetaARBB(X)
plot(thetaB)
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P. and Clémençon, S. (2006).
Regeneration-based statistics for Harris recurrent
Markov chains.
\emph{Lecture notes in Statistics}, vol. \bold{187}, pp. 1-54, Springer.
}
\seealso{
\code{\link{GetPseudoBlocks}}, \code{\link{fastNadaraya}},
\code{\link{regenboot}}, \code{\link{smallEnsemble}},\code{\link{findBestEpsilon}}.
}
\keyword{"Approximate}
\keyword{"Extremal}
\keyword{"Markov}
\keyword{"Small}
\keyword{Block"}
\keyword{Regenerative}
\keyword{chains"}
\keyword{index"}
\keyword{set"}
