% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naradamar.R
\name{naradamar}
\alias{naradamar}
\title{Nadaraya-Watson Estimator for Transition Densities.}
\usage{
naradamar(Sx, Sy, x, bandwidth)
}
\arguments{
\item{Sx}{A vector of the first coordinate of the grid for which the
Nadaraya-Watson kernel estimator will be computed.}

\item{Sy}{A vector of the second coordinate of the grid for which the
Nadaraya-Watson kernel estimator will be computed.}

\item{x}{A numeric vector representing a Markov chain.}

\item{bandwidth}{A positive numeric value representing the kernel bandwidth smoothing parameter.}
}
\value{
Returns a matrix of size \code{Sx}\eqn{\cdot}\code{Sy}, containing
the estimated transition densities on the grid.
}
\description{
Calculates the Nadaraya-Watson estimator for estimating the transition densities
of a Markov chain.
}
\details{
The \code{naradamar} function computes the estimated transition densities
\eqn{f(x, y)} of a process \code{x} on a grid given by the \code{Sx} and \code{Sy}
values. It utilizes a Nadaraya kernel-type
estimator for the transition density, with a \code{bandwidth} provided by the user.
}
\examples{
set.seed(12345)
phi=0.4
n=200
X <- arima.sim(list(ar=phi),n=n)
s=seq(quantile(X,0.01),quantile(X,0.99), length.out=50)
h=bandw1(X)
res=naradamar(s,s,X,h)
persp(s,s,res)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted..
}
\seealso{
\code{\link{bandw1}}.
}
\keyword{"Markov}
\keyword{"Transition}
\keyword{chains"}
\keyword{density}
\keyword{estimation"}
