\name{meanCoeff, acfCoeff}
\alias{meanCoeff}
\alias{acfCoeff}
\alias{meanCoeff.default}
\alias{acfCoeff.default}
\alias{meanCoeff.ts}
\alias{acfCoeff.ts}

\title{Fourier Coefficients Estimation of the Mean and Autocovariance Functions.}

\description{
For both periodically (PC) and almost periodically correlated (APC) data,
the functions calculate the Fourier coefficients of the mean and
autocovariance functions. The function can also be used for bootstrap
samples obtained with the EMBB, CEMBB, GSBB, CGSBB.
}

\usage{
    meanCoeff(x, period, freq, \dots)
    acfCoeff(x, tau, period, freq, \dots)

    \method{meanCoeff}{default}(x, period, freq, \dots)
    \method{acfCoeff}{default}(x, tau, period, freq, \dots)

    \method{meanCoeff}{ts}(x, period=frequency(x), freq, \dots)
    \method{acfCoeff}{ts}(x, tau, period=frequency(x), freq, \dots)
}

\arguments{
    \item{x}{A vector or time series representing a periodically or almost periodically correlated time series.}
    \item{period}{A positive integer; the period length. By default it is \code{frequency(x)}.}
    \item{tau}{A vector of integers; a single lag or vector of lags.}
    \item{freq}{A numeric vector of frequencies.}
    \item{\dots}{Optional additional arguments for the function.}
}

\details{
If the \code{freq} argument is not specified, the Fourier frequencies are used:
\eqn{2*k*pi/period} for \emph{k=0,1,\dots,period}, where \code{period} is the frequency of the time series.

The \code{meanCoeff} function implements the estimator of the Fourier coefficient of the mean
at frequency \eqn{\gamma}:
\deqn{\widehat{b}(\gamma) = \frac{1}{n}\sum_{t=1}^n X_t e^{-i\gamma t}.}

The \code{acfCoeff} function implements the estimator of the Fourier
coefficient of the autocovariance for given lag \code{tau} at frequency
\eqn{\lambda}:
\deqn{\widehat{a}(\lambda,\tau) = \frac{1}{n}\sum_{t=1-\min\{\tau,0\}}^{n-\max\{\tau,0\}} (X_{t+\tau}-\widehat{\mu}_n(t+\tau))
 (X_{t}-\widehat{\mu}_n(t))e^{-i\lambda t}.}
}

\value{
\code{meanCoeff} returns a vector of the same length as \code{freq}.

\code{acfCoeff} returns either a vector of length \code{length(freq)} if a single
lag \code{tau} is specified, or a matrix with \code{length(tau)} rows and \code{length(freq)}
columns if \code{tau} is a vector.
}

\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for 
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted..

Dudek, A.E. (2015). Circular block bootstrap for coefficients of autocovariance function of almost periodically correlated time series. \emph{Metrika}, \bold{78},  313-335.

Dudek, A.E. Maiz, S. and  Elbadaoui, M. (2014). Generalized Seasonal Block Bootstrap in  frequency analysis of cyclostationary signals. \emph{ Signal Process.}, \bold{104C}, 358-368.
}

\seealso{
\code{\link{seasonalMean}},
\code{\link{seasonalVar}},
\code{\link{seasonalACF}}
}

\examples{
# Fourier frequencies for the data nottem (temperatures at Nottingham Castle)
meanCoeff(nottem)
acfCoeff(nottem, 5)

# Given frequencies
freq <- 2 * (0:5) * pi / 12
meanCoeff(nottem, freq = freq)
}

\keyword{Frequency domain}
\keyword{Fourier coefficients estimators}
\keyword{Periodic time series}
