% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path-operations.R
\name{boilerplate_path_ops}
\alias{boilerplate_path_ops}
\alias{boilerplate_add_entry}
\alias{boilerplate_update_entry}
\alias{boilerplate_remove_entry}
\alias{boilerplate_get_entry}
\alias{boilerplate_sort_db}
\alias{boilerplate_path_exists}
\alias{boilerplate_list_paths}
\title{Path-Based Database Operations}
\usage{
boilerplate_add_entry(db, path, value, auto_sort = TRUE)

boilerplate_update_entry(db, path, value, auto_sort = TRUE)

boilerplate_remove_entry(db, path, auto_sort = TRUE)

boilerplate_get_entry(db, path)

boilerplate_sort_db(db)

boilerplate_path_exists(db, path)

boilerplate_list_paths(db, prefix = "")
}
\arguments{
\item{db}{List. The database to examine.}

\item{path}{Character. Dot-separated path.}

\item{value}{Any. The value to set.}

\item{auto_sort}{Logical. Whether to auto-sort at each level. Default \code{TRUE}.}

\item{prefix}{Character. Optional prefix for path construction.}
}
\value{
Modified database (list).

Modified database (list).

Modified database (list).

The value at the specified path.

The sorted database.

Logical. \code{TRUE} if the path exists, \code{FALSE} otherwise.

Character vector of all available paths.
}
\description{
These functions manipulate databases using dot-separated paths, preserving nesting.
}
