% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.bmmfit}
\alias{summary.bmmfit}
\title{Create a summary of a fitted model represented by a \code{bmmfit} object}
\usage{
\method{summary}{bmmfit}(
  object,
  priors = FALSE,
  prob = 0.95,
  robust = FALSE,
  mc_se = FALSE,
  ...,
  backend = "bmm"
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{priors}{Logical; Indicating if priors should be included
in the summary. Default is \code{FALSE}.}

\item{prob}{A value between 0 and 1 indicating the desired probability
to be covered by the uncertainty intervals. The default is 0.95.}

\item{robust}{If \code{FALSE} (the default) the mean is used as
the measure of central tendency and the standard deviation as
the measure of variability. If \code{TRUE}, the median and the
median absolute deviation (MAD) are applied instead.}

\item{mc_se}{Logical; Indicating if the uncertainty in \code{Estimate}
caused by the MCMC sampling should be shown in the summary. Defaults to
\code{FALSE}.}

\item{...}{Other potential arguments}

\item{backend}{Choose whether to display the \emph{bmm} summary method (default),
or to display the \emph{brms} summary method.}
}
\value{
A list of class \code{bmmsummary} containing the summary of the model's
parameters, the model formula, the model, and the data used to fit the model.
}
\description{
Create a summary of a fitted model represented by a \code{bmmfit} object
}
\note{
You can turn off the color output by setting the option
options(bmm.color_summary = FALSE) or bmm_options(color_summary = FALSE)
}
\examples{
\dontshow{if (isTRUE(Sys.getenv("BMM_EXAMPLES"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# generate artificial data from the Signal Discrimination Model
dat <- data.frame(y = rsdm(2000))

# define formula
ff <- bmmformula(c ~ 1, kappa ~ 1)

# fit the model
fit <- bmm(
  formula = ff,
  data = dat,
  model = sdm(resp_error = "y"),
  cores = 4,
  backend = "cmdstanr"
)

# summary of the model
summary(fit)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[brms]{summary.brmsfit}}
}
