% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{new_bind_rows_block}
\alias{new_bind_rows_block}
\title{Bind Rows Block Constructor}
\usage{
new_bind_rows_block(id_name = "", ...)
}
\arguments{
\item{id_name}{Character string, name for the ID column. If non-empty, adds
a column identifying source data frames. Default "" (disabled).}

\item{...}{Forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A block object for bind_rows operations
}
\description{
This block allows for row-wise combination of two or more data frames
using \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}. It stacks data frames vertically, matching
columns by name and filling missing columns with NA values.
}
\examples{
# Create a bind rows block
new_bind_rows_block()

if (interactive()) {
  library(blockr.core)
  library(blockr.dplyr)

  # Basic usage - stack filtered datasets
  serve(
    new_board(
      blocks = list(
        iris_data = new_dataset_block(dataset = "iris"),
        setosa = new_filter_expr_block(exprs = list("Species == 'setosa'")),
        versicolor = new_filter_expr_block(exprs = list("Species == 'versicolor'")),
        combined = new_bind_rows_block()
      ),
      links = links(
        from = c("iris_data", "iris_data", "setosa", "versicolor"),
        to = c("setosa", "versicolor", "combined", "combined"),
        input = c("data", "data", "1", "2")
      )
    )
  )

  # With ID column to track source
  serve(
    new_board(
      blocks = list(
        iris_data = new_dataset_block(dataset = "iris"),
        setosa = new_filter_expr_block(exprs = list("Species == 'setosa'")),
        versicolor = new_filter_expr_block(exprs = list("Species == 'versicolor'")),
        combined = new_bind_rows_block(id_name = "source")
      ),
      links = links(
        from = c("iris_data", "iris_data", "setosa", "versicolor"),
        to = c("setosa", "versicolor", "combined", "combined"),
        input = c("data", "data", "1", "2")
      )
    )
  )
}

}
