% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSquare.R
\name{toer,ChiSquare-method}
\alias{toer,ChiSquare-method}
\title{Type I Error Rate}
\usage{
\S4method{toer}{ChiSquare}(
  design,
  n1,
  nuisance,
  recalculation,
  allocation = c("exact", "approximate", "kf_approx"),
  ...
)
}
\arguments{
\item{design}{Object of class \code{ChiSquare} created by \code{setupChiSquare}.}

\item{n1}{Either the sample size of the first stage (if
\code{recalculation = TRUE} or the total sample size (if
\code{recalculation = FALSE}).}

\item{nuisance}{Value of the nuisance parameter in (0,1). For the
Chi-Squared test this is the overall response rate.}

\item{recalculation}{Should the sample size be recalculated after n1
patients are recruited?}

\item{allocation}{Whether the allocation ratio should be preserved
exactly (\code{exact}) or approximately (\code{approximate}
or \code{kf_approx}). \code{appproximate} uses the unrounded calculated
sample size in the sample size recalculation, \code{kf_approx}
rounds the sample size to the next integer.}

\item{...}{Further optional arguments.}
}
\value{
One type I error rate value for every nuisance parameter and
  every value of n1.
}
\description{
Computes the type I error rate of designs with blinded sample size
recalculation or of fixed designs for one or several values of the
nuisance parameter.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.
}
\examples{
  d <- setupChiSquare(alpha = 0.025, beta = 0.2, r = 1, delta = 0.2)
  toer(d, n1 = c(10, 20), nuisance = 0.25, recalculation = TRUE)

}
