% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Student.R
\name{n_fix,Student-method}
\alias{n_fix,Student-method}
\title{Fixed Sample Size}
\usage{
\S4method{n_fix}{Student}(design, nuisance, ...)
}
\arguments{
\item{design}{test statistic object}

\item{nuisance}{nuisance parameter}

\item{...}{Further optional arguments.}
}
\value{
One value of the fixed sample size for every nuisance parameter
 and every value of n1.
}
\description{
Returns the sample size of a fixed design without sample size recalculation.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.
}
\examples{
d <- setupStudent(alpha = .025, beta = .2, r = 1, delta = 3.5, delta_NI = 0,
                  alternative = "greater", n_max = 156)
n_fix(design = d, nuisance = 5.5)

}
