% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{biplot}
\alias{biplot}
\title{First step to create a new biplot with \pkg{biplotEZ}}
\usage{
biplot(data, classes = NULL, group.aes = NULL, center = TRUE, scaled = FALSE,
Title = NULL)
}
\arguments{
\item{data}{a data frame or numeric matrix containing all variables the user wants to analyse.}

\item{classes}{a vector identifying class membership.}

\item{group.aes}{a vector identifying groups for aesthetic formatting.}

\item{center}{a logical value indicating whether \code{data} should be column centered, with default \code{TRUE}.}

\item{scaled}{a logical value indicating whether \code{data} should be standardised to unit column variances, with default \code{FALSE}.}

\item{Title}{the title of the biplot to be rendered, enter text in "  ".}
}
\value{
A list with the following components is available:
\item{X}{the matrix of the centered and scaled numeric variables.}
\item{Xcat}{the data frame of the categorical variables.}
\item{raw.X}{the original data.}
\item{classes}{the vector of category levels for the class variable. This is to be used for \code{colour}, \code{pch} and \code{cex} specifications.}
\item{na.action}{the vector of observations that have been removed.}
\item{center}{a logical value indicating whether \eqn{\mathbf{X}} is centered.}
\item{scaled}{a logical value indicating whether \eqn{\mathbf{X}} is scaled.}
\item{means}{the vector of means for each numeric variable.}
\item{sd}{the vector of standard deviations for each numeric variable.}
\item{n}{the number of observations.}
\item{p}{the number of variables.}
\item{group.aes}{the vector of category levels for the grouping variable. This is to be used for \code{colour}, \code{pch} and \code{cex} specifications.}
\item{g.names}{the descriptive names to be used for group labels.}
\item{g}{the number of groups.}
\item{Title}{the title of the biplot rendered}
}
\description{
This function produces a list of elements to be used when producing a biplot,
which provides a useful data analysis tool and allows the visual appraisal
of the structure of large data matrices. Biplots are the
multivariate analogue of scatter plots. They approximate the multivariate
distribution of a sample in a few dimensions and they superimpose on this
display representations of the variables on which the samples are measured.
}
\details{
This function is the entry-level function in \code{biplotEZ} to construct a biplot display.
It initialises an object of class \code{biplot} which can then be piped to various other functions
to build up the biplot display.
}
\section{Useful links}{


The biplot display can be built up in four broad steps depending on the needs for the display.
Firstly, choose an appropriate method to construct the display;
Secondly, change the aesthetics of the display;
Thirdly, append the display with supplementary features such as axes, samples and means;
Finally, superimpose shapes, characters or elements onto the display.

\strong{1. Different types of biplots:}
\itemize{
\item \code{\link[=PCA]{PCA()}}: Principal Component Analysis biplot of various dimensions
\item \code{\link[=CVA]{CVA()}}: Canonical Variate Analysis biplot
\item \code{\link[=PCO]{PCO()}}: Principal Coordinate Analysis biplot
\item \code{\link[=CA]{CA()}}: Correspondence Analysis biplot
\item \code{\link[=regress]{regress()}}: Regression biplot method
}

\strong{2. Customise the biplot display with aesthetic functions:}
\itemize{
\item \code{\link[=samples]{samples()}}: Change the formatting of sample points on the biplot display
\item \code{\link[=axes]{axes()}}: Change the formatting of the biplot axes
}

\strong{3. Supplement the existing biplot with additional axes, samples and group means:}
\itemize{
\item \code{\link[=newsamples]{newsamples()}}: Add and change formatting of additional samples
\item \code{\link[=newaxes]{newaxes()}}: Add and change formatting of additional axes
\item \code{\link[=means]{means()}}: Insert class means to the display, and format appropriately
}

\strong{4. Append the biplot display:}
\itemize{
\item \code{\link[=alpha.bags]{alpha.bags()}}: Add \eqn{\alpha}-bags
\item \code{\link[=ellipses]{ellipses()}}: Add ellipses
\item \code{\link[=density2D]{density2D()}}: Add 2D density regions
}

\strong{Other useful links:}
\itemize{
\item \code{\link[=plot]{plot()}}
\item \code{\link[=fit.measures]{fit.measures()}}
\item \code{\link[=legend.type]{legend.type()}}
\item \code{\link[=interpolate]{interpolate()}}
\item \code{\link[=prediction]{prediction()}}
\item \code{\link[=classify]{classify()}}
\item \code{\link[=reflect]{reflect()}}
\item \code{\link[=rotate]{rotate()}}
}
}

\examples{
biplot(data = iris)
# create a PCA biplot
biplot(data = iris) |> PCA() |> plot()

}
\references{
Gabriel, K.R. (1971) The biplot graphic display of matrices with application to principal component analysis. \emph{Biometrika.} 58(3):453–467.

Gower, J., Gardner-Lubbe, S. & Le Roux, N. (2011, ISBN: 978-0-470-01255-0) \emph{Understanding Biplots.} Chichester, England: John Wiley & Sons Ltd.

Gower, J.C. & Hand, D.J.(1996, ISBN: 0-412-71630-5) \emph{Biplots.} London: Chapman & Hall.
}
