% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NI.A2M.R
\name{MasterPool.Array.Measures}
\alias{MasterPool.Array.Measures}
\title{Operating characteristics for array testing with master pooling}
\usage{
MasterPool.Array.Measures(results, n, pmat, Se, Sp)
}
\arguments{
\item{results}{an object containing results (expected number of tests and 
accuracy measures) from \code{\link{Array.Measures}}.}

\item{n}{size of a row/column in the square array.}

\item{pmat}{matrix of individual risk probabilities.}

\item{Se}{the sensitivity of the diagnostic test.}

\item{Sp}{the specificity of the diagnostic test.}
}
\value{
A list containing:
\item{ET}{the expected number of tests for the array.}
\item{PSe}{a matrix containing each individual's pooling sensitivity, 
corresponding to the input matrix of individual probabilities.}
\item{PSp}{a matrix containing each individual's pooling specificity, 
corresponding to the input matrix of individual probabilities.}
\item{PPV}{a matrix containing each individual's pooling positive predictive
value, corresponding to the input matrix of individual probabilities.}
\item{NPV}{a matrix containing each individual's pooling negative predictive
value, corresponding to the input matrix of individual probabilities.}
}
\description{
Calculate the expected number of tests and accuracy measures
for each individual using array testing with master pooling.
}
\details{
This function assumes that the array is square (i.e., the row
and column size are equal) and utilizes the equations from Kim et al. 
(2007) for square array testing with master pooling. This function 
calculates the operating characteristics for array testing with master 
pooling. Operating characteristics calculated are expected number of tests, 
pooling sensitivity, pooling specificity, pooling positive predictive value, 
and pooling negative predictive value for each individual.
}
\section{Note}{
 This function returns the pooling positive and negative
predictive values for all individuals in the array even though these
measures are diagnostic specific; i.e., PPV (NPV) should only be considered
for those individuals who have tested positive (negative).
}

\examples{
# Calculate the operating characteristics for 
#   non-informative array testing with master
#   pooling, with a 6x6 array and an overall 
#   disease risk of p = 0.10.
# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
p.mat <- matrix(data=0.10, ncol=6, nrow=6)
results <- Array.Measures(p=p.mat, se=0.90, sp=0.90)
MasterPool.Array.Measures(results=results, n=36, 
pmat=p.mat, Se=0.90, Sp=0.90)
}
\references{
\insertRef{Kim2007}{binGroup}
}
\seealso{
\code{\link{Array.Measures}} for calculating operating 
characteristics under array testing without master pooling, 
\code{\link{hierarchical.desc2}} for three-stage hierarchical and 
non-informative two-stage hierarchical testing, and 
\code{\link{inf.dorf.measures}} for informative two-stage hierarchical 
testing.

Other Operating characteristic functions: 
\code{\link{Array.Measures}()},
\code{\link{hierarchical.desc2}()},
\code{\link{inf.dorf.measures}()}
}
\author{
Brianna D. Hitt
}
\concept{Operating characteristic functions}
