% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{solve_linear_system}
\alias{solve_linear_system}
\title{Solve (A + lam I) x = b}
\usage{
solve_linear_system(A, b, add_to_diag = 0)
}
\arguments{
\item{A}{A \emph{symmetric} square matrix.}

\item{b}{A vector.}

\item{add_to_diag}{One value to add to the diagonal of A (lam). Default is 0.}
}
\value{
The best solution \code{x} of this linear system.
}
\description{
Solve (A + lam I) x = b
}
\examples{
A <- matrix(rnorm(4), 2); A[1, 2] <- A[2, 1]  # should be symmetric
x <- rnorm(2)
b <- A \%*\% x
x2 <- drop(solve(A, b))
x3 <- solve_linear_system(A, b)
rbind(x, x2, x3)

}
