% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa-generics-as_bids_tabular.R,
%   R/class013-bids_tabular.R
\name{as_bids_tabular}
\alias{as_bids_tabular}
\alias{save_bids_tabular}
\alias{BIDSTabular}
\alias{BIDSTabularColumnDescriptor}
\alias{BIDSTabularMetaSidecar}
\alias{save_bids_tabular_default}
\alias{new_bids_tabular_class}
\title{Class definitions and utilities for 'BIDS' tabular}
\usage{
as_bids_tabular(x, ...)

save_bids_tabular(x, path, meta = TRUE, ...)

BIDSTabularColumnDescriptor(..., .list = list())

BIDSTabularMetaSidecar(columns = list())

BIDSTabular(content, meta = NULL)

save_bids_tabular_default(
  x,
  path,
  meta = TRUE,
  compact_meta = TRUE,
  milliseconds = TRUE,
  utc = TRUE,
  ...
)

new_bids_tabular_class(
  table_name,
  parent = BIDSTabular,
  content_setter = NULL,
  meta_preset = NULL,
  prepare_save = NULL,
  lower_case_column_names = FALSE
)
}
\arguments{
\item{x}{R object that can be converted (e.g. list, table), or a path
to a tabular file.}

\item{..., .list}{for \code{BIDSTabularColumnDescriptor}, this is
a list of key-value properties; for \code{as_bids_tabular}, this is passed
to \code{BIDSTabularMetaSidecar}}

\item{path}{path to save the file; the file is always saved as
tabular-separated value ('TSV') format}

\item{meta}{instance of \code{BIDSTabularMetaSidecar}, a class containing
a list of descriptors for each column (see argument \code{columns})}

\item{columns}{a named list, where each key correspond to a table column
name, and each item is a named list of descriptors, or a
\code{BIDSTabularColumnDescriptor} instance}

\item{content}{a data frame or table with column names non-blanks and
possibly all in snake-cases (see specification); \code{bidsr} does not check
on the column names for compatibility concerns. However users should respect
the specification and use the recommended conventions}

\item{compact_meta}{logical, whether the meta side-car ('JSON' file) should
use compact format; default is true}

\item{milliseconds, utc}{used to convert \code{\link[nanotime]{nanotime}}
to 'BIDS' time-stamp format; default is to keep the milliseconds and use
'UTC' timezone.}

\item{table_name}{name of the table, used to generate a new class;
the class name will be \code{BIDSTabular_<table_name>}}

\item{parent}{parent class of the new class; default is \code{BIDSTabular}}

\item{content_setter}{a \code{setter} function to set the content; see
\code{\link{bids_property}}}

\item{meta_preset}{a \code{preset} function to set the meta; see
\code{BIDSTabularMetaSidecar}}

\item{prepare_save}{a function to prepare the content before saving; should
take the \code{BIDSTabular} object as the first argument, and return the
content to be saved}

\item{lower_case_column_names}{if \code{TRUE}, the column names will be
converted to lower case; default is \code{TRUE}}
}
\value{
A component in \code{BIDSTabular}.
}
\description{
Official specification link:
\url{https://bids-specification.readthedocs.io/en/stable/common-principles.html#tabular-files}.
Function \code{save_tabular} is the high-level generic function that by
default calls low-level function \code{save_bids_tabular_default} by default.
}
\examples{



# convert a data table into BIDS tabular
table <- data.frame(
  a = c(1, 2, 3, NA, NA, 6, 7, 8, 9, 10),
  b = sample(c('a', 'b'), size = 10, replace = TRUE)
)

# basic
as_bids_tabular(table)

# add descriptors
tabular <- as_bids_tabular(
  table,
  a = list(LongName = "An integer"),
  b = list("Levels" = list('a' = "Abnormal", 'b' = "Bipolar"))
)
tabular


# query data
is.data.frame(tabular$content)
tabular$content$a

# query meta
tabular$meta$columns$a

# save to tsv
tsv <- tempfile(fileext = ".tsv")
paths <- save_bids_tabular(tabular, tsv)
print(paths)

# use base R to read
read.table(tsv, header = TRUE, na.strings = "n/a")

# get sidecar
cat(readLines(paths$sidecar_path), sep = "\n")

unlink(tsv)
unlink(paths$sidecar_path)



}
\author{
Zhengjia Wang
}
