% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class030-bids_dataset_description.R
\name{BIDSDatasetGeneratedBy}
\alias{BIDSDatasetGeneratedBy}
\title{Class definition for 'BIDS' meta-data \code{'GeneratedBy'}}
\usage{
BIDSDatasetGeneratedBy(
  Name = character(0),
  Version = character(0),
  Description = character(0),
  CodeURL = character(0),
  Container = list()
)
}
\arguments{
\item{Name}{(character, required) name of the pipeline or process that
generated the outputs.}

\item{Version}{(character, optional) version of the pipeline}

\item{Description}{(character, optional) plain-text description of the pipeline or process that generated the outputs.}

\item{CodeURL}{(character, optional) 'URL' where the code used to generate
the data may be found.}

\item{Container}{(character, optional) Used to specify the location and
relevant attributes of software container image used to produce the data.
Valid keys in this object include type, tag 'URL' with string values.
Package \code{'bidsr'} does not check what's inside of this entry.}
}
\value{
Instantiated object of class \code{BIDSDatasetGeneratedBy}
}
\description{
See definition at \url{https://bids-specification.readthedocs.io/en/stable/glossary.html#objects.metadata.GeneratedBy}
}
\examples{

x <- BIDSDatasetGeneratedBy(
  Name = "RAVE Team",
  Version = "0.0.1",
  Container = list(
    Type = "docker",
    Tag = "rave-ieeg/rave-pipelines:0.0.1"
  )
)

x

x$Version <- "0.0.2"

# convert to basic list
as.list(x)

# get JSON string
format(x)

}
\author{
Zhengjia Wang
}
