% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curveFunctions.R
\name{doubleGauss_sac}
\alias{doubleGauss_sac}
\title{Double Gauss curve function for nlme}
\usage{
doubleGauss_sac(dat, y, time, params = NULL, startSamp = 8, ...)
}
\arguments{
\item{dat}{subject data to be used}

\item{y}{outcome variable, character vector}

\item{time}{time variable, character vector}

\item{params}{\code{NULL} unless user wants to specify starting parameters for gnls}

\item{startSamp}{how many samples from distribution should we use to investigate}

\item{...}{just in case}
}
\description{
Double Gauss function used in fitting nlme curve for observations but now even
better since it samples across a sensible distribution for starting parameters
}
\details{
User should only have to worry about setting concavity
of this function

\code{y ~ (time < mu) * (exp(-1 * (time - mu) ^ 2
/ (2 * sig1 ^ 2)) * (ht - base1) + base1)
+ (mu <= time) * (exp(-1 * (time - mu) ^ 2
                         / (2 * sig2 ^ 2)) * (ht - base2) + base2)}
}
