% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdlim1.R
\name{bdlim1}
\alias{bdlim1}
\title{Fit the BDLIM model with 1 pattern of modification}
\usage{
bdlim1(
  y,
  exposure,
  covars,
  group,
  id = NULL,
  w_free,
  b_free,
  df,
  nits,
  nburn = round(nits/2),
  nthin = 1,
  progress = TRUE
)
}
\arguments{
\item{y}{A vector of outcomes}

\item{exposure}{A matrix of exposures with one row for each individual}

\item{covars}{A matrix or data.frame of covariates This should not include the grouping factor (see group below). This may include factor variables.}

\item{group}{A vector of group memberships. This should be a factor variable.}

\item{id}{An optional vector of individual IDs if there are repeated measures or other groupings that a random intercept should be included for. This must be a factor variable.}

\item{w_free}{Logical indicating if the weight functions are shared by all groups (FALSE) or group-specific (TRUE).}

\item{b_free}{Logical indicating if the effect sizes are shared by all groups (FALSE) or group-specific (TRUE).}

\item{df}{Degrees of freedom for the weight functions}

\item{nits}{Number of MCMC iterations.}

\item{nburn}{Number of MCMC iterations to be discarded as burn in. The default is half if the MCMC iterations. This is only used for WAIC in this function but is passed to summary and plot functions and used there.}

\item{nthin}{Thinning factors for the MCMC. This is only used for WAIC in this function but is passed to summary and plot functions and used there.}

\item{progress}{Logical indicating if a progress bar should be shown during MCMC iterations. Default is TRUE.}
}
\value{
A list with posteriors of parameters
}
\description{
Fit the BDLIM model with 1 pattern of modification
}
\examples{
\donttest{

# run BDLIM with modification by ChildSex
fit_sex <- bdlim1(
  y = sbd_bdlim$bwgaz,
  exposure = sbd_bdlim[,paste0("pm25_",1:37)],
  covars = sbd_bdlim[,c("MomPriorBMI","MomAge","race","Hispanic",
                                   "EstMonthConcept","EstYearConcept")],
  group = as.factor(sbd_bdlim$ChildSex),
  w_free = TRUE,
  b_free = TRUE,
  df = 5,
  nits = 5000
)

# show model fit results
fit_sex

#summarize results
sfit_sex <- summary(fit_sex)
sfit_sex

# graph the estimated distributed lag functions for each group
plot(sfit_sex)


# run BDLIM with no modification
# here a single group is put in for group
# the group must be a factor
# w_free and b_free must be FALSE because modification is not allowed with only one group
fit_onegroup <- bdlim1(
  y = sbd_bdlim$bwgaz,
  exposure = sbd_bdlim[,paste0("pm25_",1:37)],
  covars = sbd_bdlim[,c("MomPriorBMI","MomAge","race","Hispanic",
                        "EstMonthConcept","EstYearConcept")],
  group = as.factor(rep("A",nrow(sbd_bdlim))),
  w_free = FALSE,
  b_free = FALSE,
  df = 5,
  nits = 5000
)

# show model fit results
fit_onegroup

#summarize results
sfit_onegroup <- summary(fit_onegroup)
sfit_onegroup

# graph the estimated distributed lag functions for the one group
plot(sfit_onegroup)

# extract the weight function
getw(fit_onegroup)

}
}
