% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utm-convert.R
\name{utm_convert}
\alias{utm_convert}
\title{Convert a data.frame of UTM coordinates to an sf object with a single CRS}
\usage{
utm_convert(
  x,
  easting,
  northing,
  zone,
  crs = "EPSG:3005",
  datum = c("NAD83", "WGS84"),
  xycols = TRUE
)
}
\arguments{
\item{x}{data.frame containing UTM coordinates, with a zone column}

\item{easting}{the name of the 'easting' column}

\item{northing}{the name of the 'northing' column}

\item{zone}{the name of the 'zone' column, or a single value if
the data are all in one UTM zone}

\item{crs}{target CRS. Default BC Albers (EPSG:3005)}

\item{datum}{The datum of the source data. \code{"NAD83"} (Default) or \code{"WGS84"}}

\item{xycols}{should the X and Y columns be appended to the output? \code{TRUE} or \code{FALSE}}
}
\value{
sf object in the chosen CRS
}
\description{
This can operate on a data frame containing coordinates from multiple UTM zones
with a column denoting the zone, or a single zone for the full dataset.
}
\details{
It supports data collected in either the NAD83 or WGS84 ellipsoid in
the Northern hemisphere
}
\examples{
# Data with multiple zones, and a column denoting the zone
df <- data.frame(
  animalid = c("a", "b", "c"),
  zone = c(10, 11, 11),
  easting = c(500000, 800000, 700000),
  northing = c(5000000, 3000000, 1000000)
)
utm_convert(df, easting = "easting", northing = "northing", zone = "zone")

# Data all in one zone, specify a single zone:
df <- data.frame(
  animalid = c("a", "b"),
  easting = c(500000, 800000),
  northing = c(5000000, 3000000)
)
utm_convert(df, easting = "easting", northing = "northing", zone = 11)
}
