% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesianOU-package.R
\docType{package}
\name{bayesianOU-package}
\alias{bayesianOU-package}
\alias{bayesianOU}
\title{bayesianOU: Bayesian Nonlinear Ornstein-Uhlenbeck Models}
\description{
Fits Bayesian nonlinear Ornstein-Uhlenbeck models with cubic drift,
stochastic volatility (SV), and Student-t innovations. The package
implements hierarchical priors for sector-specific parameters and
supports parallel MCMC sampling via 'Stan'.
}
\section{Main Functions}{

\itemize{
   \item \code{\link{fit_ou_nonlinear_tmg}}: Fit the main OU model
   \item \code{\link{extract_posterior_summary}}: Extract posterior summaries
   \item \code{\link{validate_ou_fit}}: Validate model fit
   \item \code{\link{compare_models_loo}}: Compare models via PSIS-LOO
}
}

\section{Model Specification}{

The model implements a nonlinear OU process with cubic drift:
\deqn{dY_t = \kappa(\theta - Y_t + a_3 (Y_t - \theta)^3) dt + \sigma_t dW_t}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/isadorenabi/bayesianOU}
  \item Report bugs at \url{https://github.com/isadorenabi/bayesianOU/issues}
}

}
\author{
\strong{Maintainer}: José Mauricio Gómez Julián \email{isadore.nabi@pm.me} (\href{https://orcid.org/0009-0000-2412-3150}{ORCID})

}
\keyword{internal}
