% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_models.R
\name{stan_SVM}
\alias{stan_SVM}
\title{Fitting a Stochastic volatility model.}
\usage{
stan_SVM(
  ts,
  arma = c(0, 0),
  xreg = NULL,
  chains = 4,
  iter = 2000,
  warmup = floor(iter/2),
  adapt.delta = 0.9,
  tree.depth = 10,
  prior_mu0 = NULL,
  prior_sigma0 = NULL,
  prior_ar = NULL,
  prior_ma = NULL,
  prior_alpha = NULL,
  prior_beta = NULL,
  prior_breg = NULL,
  series.name = NULL,
  ...
)
}
\arguments{
\item{ts}{a numeric or ts object with the univariate time series.}

\item{arma}{Optionally, a specification of the  ARMA model,same
as order parameter: the two components (p, q) are the AR order,and
the  MA order.}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{chains}{an integer of the number of Markov Chains chains to be run. By
default, \code{chains = 4}.}

\item{iter}{an integer of total iterations per chain including the warm-up. By
default, \code{iter = 2000}.}

\item{warmup}{a positive integer specifying number of warm-up (aka burn-in)
iterations. This also specifies the number of iterations used for step-size
adaptation, so warm-up samples should not be used for inference. The number
of warmup iteration should not be larger than \code{iter}.By default,
\code{warmup = iter/2}.}

\item{adapt.delta}{an optional real value between 0 and 1, the thin of the jumps
in a HMC method. By default, is 0.9.}

\item{tree.depth}{an integer of the maximum depth of the trees  evaluated
during each iteration. By default, is 10.}

\item{prior_mu0}{The prior distribution for the location parameter in an
ARIMA model. By default, sets \code{student(7,0,1)} prior.}

\item{prior_sigma0}{The prior distribution for the scale parameter in an
ARIMA model. By default, declares a \code{student(7,0,1)} prior.}

\item{prior_ar}{The prior distribution for the auto-regressive parameters in
an ARMA model. By default, sets \code{normal(0,0.5)} priors.}

\item{prior_ma}{The prior distribution for the moving average parameters in
an ARMA model. By default, sets the \code{normal(0,0.5)} priors.}

\item{prior_alpha}{The prior distribution for the auto-regressive parameters in
a SVM model. By default, set a \code{normal(0, 0.5)} prior.}

\item{prior_beta}{The prior distribution for the exponential intercept parameter
in a SVM model. By default, uses a \code{normal(0,0.5)} prior.}

\item{prior_breg}{The prior distribution for the regression coefficient parameters
in an ARIMAX model. By default, sets \code{student(7,0,1)} priors.}

\item{series.name}{an optional string vector with the series names.}

\item{...}{Further arguments passed to  \code{varstan} function.}
}
\value{
A \code{varstan} object with the fitted SVM model.
}
\description{
Fitting a Stochastic Volatility model (SVM) in \pkg{Stan}.
}
\details{
The function returns a \code{varstan} object with the fitted model.
}
\examples{
\donttest{
 # Declares a SVM model for the IPC data
 sf1 = stan_SVM(ipc,arma = c(1,1),iter = 500,chains = 1)
}

}
\references{
Sangjoon,K. and Shephard, N. and Chib.S (1998). Stochastic Volatility: Likelihood
Inference and Comparison with ARCH Models. \emph{Review of Economic Studies}.
65(1), 361-93. \code{url: https://www.jstor.org/stable/2566931}.

Tsay, R (2010). Analysis of Financial Time Series.
\emph{Wiley-Interscience}. 978-0470414354, second edition.

Shumway, R.H. and Stoffer, D.S. (2010).Time Series Analysis and Its
Applications: With R Examples. \emph{Springer Texts in Statistics}.
isbn: 9781441978646. First edition.
}
\seealso{
\code{garch}, and \code{set_prior}
}
\author{
Asael Alonzo Matamoros
}
