% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_anova.R
\name{summary.avaov}
\alias{summary.avaov}
\title{Summary Method for Anytime-Valid aov Objects}
\usage{
\method{summary}{avaov}(object, ...)
}
\arguments{
\item{object}{An object of class \code{avaov} created by \code{av.aov}.}

\item{...}{Additional arguments passed to or from other methods.}
}
\value{
A summary object of class \code{summary.avaov} that includes the anytime-valid p-values.
}
\description{
This method produces a summary for objects of class \code{avaov}. It first calls the
default \code{summary.aov} method and then replaces the standard p-values with anytime-valid p-values
calculated using the precision parameter \code{g}.
}
\examples{

# Fit an ANOVA model to the iris dataset.
# This model tests whether the sepal length differs by species.
fit_aov <- aov(Sepal.Length ~ Species, data = iris)

# Convert the standard aov object to an anytime-valid aov (avaov) with precision parameter g = 1.
av_fit_aov <- av(fit_aov, g = 1)

# Print the summary of the anytime-valid ANOVA model.
# The summary replaces standard p-values with anytime-valid p-values.
summary(av_fit_aov)

}
