% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestharp.R
\name{rmd_to_forestharp}
\alias{rmd_to_forestharp}
\title{Convert to TreeHarp objects}
\usage{
rmd_to_forestharp(fname, line_nums = FALSE)
}
\arguments{
\item{fname}{The filename that is to be read in.}

\item{line_nums}{A logical value, indicating if the line numbers of
expressions should be returned along with the expressions. By default, this 
value is FALSE.}
}
\value{
A list of TreeHarp objects, or a list with 2 components containing
the TreeHarp objects and a vector of line numbers.
}
\description{
Reads in an Rmd file or an R script and converts it to a list of TreeHarp
objects.
}
\details{
The TreeHarp constructor is wrapped in a tryCatch loop, so that it
does not fail if an expression could not be converted to a TreeHarp object.

The object returned is not a specially defined class. It is either a list of 
length 2, or a list of TreeHarp objects. This output is meant to be used 
with \code{\link{fapply}}.

If the input file is an Rmd file (checked with \link{extract_chunks}), then the
chunks are extracted and converted to TreeHarp objects. If the input file is 
not an Rmd, it is assumed to be an R script. This script is then supplied to 
\link{parse}. In either case, a parsing error here could cause the function to 
fail.

Line numbers are extracted using \code{\link[lintr]{get_source_expressions}} from
the lintr package.
}
\seealso{
\code{\link{fapply}}, \code{\link{extract_chunks}},
\code{\link{extract_chunks}}, \code{\link[lintr]{get_source_expressions}}
}
